﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Text;
using System.Windows.Forms;
using info.lundin.Math;
using System.Collections;
using System.Diagnostics;

namespace GraphViewr
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
            toolStripStatusLabel1.AutoSize = true;
        }
        /// <summary>
        /// 倍率
        /// </summary>
        double mag = 10;
        
        private void picTBox_Paint(object sender, PaintEventArgs e)
        {

            Rectangle rct = picTBox.ClientRectangle;
            int ox = rct.Right / 2;
            int oy = rct.Bottom / 2;
            Pen pen = new Pen(Color.Black);
            pen.DashStyle = DashStyle.Dot;
            e.Graphics.DrawLine(Pens.Black, new Point(0, oy), new Point(2 * ox, oy));
            e.Graphics.DrawLine(Pens.Black, new Point(ox, 0), new Point( ox,2 * oy));
            for (int x = ox - (int)mag; x >= 0; x -= (int)mag)
            {
                e.Graphics.DrawLine(pen, new Point(x, 0), new Point(x, rct.Bottom));
                
            }
            for (int x = ox + (int)mag; x <= rct.Right; x += (int)mag)
            {
                e.Graphics.DrawLine(pen, new Point(x, 0), new Point(x, rct.Bottom));

            }
            for (int y = oy - (int)mag; y >= 0; y -= (int)mag)
            {
                e.Graphics.DrawLine(pen, new Point(0, y), new Point(rct.Right, y));

            }
            for (int y = oy + (int)mag; y <= rct.Bottom; y += (int)mag)
            {
                e.Graphics.DrawLine(pen, new Point(0, y), new Point(rct.Right, y));

            }
            
        }
        
        private void picTBox_Resize(object sender, EventArgs e)
        {
            picTBox.Invalidate();
            picTBox.Refresh();
            DrawPage();
        }

        private void Plot_Click(object sender, EventArgs e)
        {

            picTBox.Refresh();
            
            DrawPage();
                
        }
        private void DrawPage()
        {
            ExpressionParser parser = new ExpressionParser();
            Hashtable h = new Hashtable();
            if (Function.Text == "")
                return;
            else
            {
                Graphics g = picTBox.CreateGraphics();
                PointF[] points = new PointF[10000];//(int)g.VisibleClipBounds.Width];
                int n = points.Length, i;
                float step = g.VisibleClipBounds.Width / points.Length;
                float x;

                g.TranslateTransform(picTBox.Width / 2, picTBox.Height / 2);
                g.ScaleTransform(1.0f, -1.0f);
                g.SmoothingMode = SmoothingMode.AntiAlias;
                try
                {
                    for (x = -g.VisibleClipBounds.Width / 2, i = 0; i < points.Length; i++, x += step)
                    {
                        h["x"] = x.ToString();
                        string resut = parser.Parse(Function.Text, h);
                        if (resut != null)
                        {
                            points[i] = new PointF(x * (float)mag, (float)float.Parse(resut) * (float)mag);
                        }
                    }
                }
                catch (Exception )
                {
                    MessageBox.Show("構文エラーです。");
                    return;
                }
                RectangleF pf = g.Clip.GetBounds(g);
               
                for (i = 0; i < points.Length; i++)
                {
                    float pt = points[i].Y;
                    if (pt <= pf.Top)
                        points[i].Y = pf.Top;
                    if (pt >= pf.Bottom)
                        points[i].Y = pf.Bottom;
                }

                g.DrawLines(Pens.Blue, points);


                g.Dispose();
            }
           
        }

        private void picTBox_MouseMove(object sender, MouseEventArgs e)
        {
            toolStripStatusLabel1.Text = "(X = " + ((float)((e.X-picTBox.ClientRectangle.Right/2)/mag)).ToString() + "," + "Y = " + ((float)((-e.Y+picTBox.ClientRectangle.Bottom/2)/mag)).ToString()  + ")";
        }
    }
}